// callnowDlg.cpp : implementation file
//

#include "stdafx.h"
#include "callnow.h"
#include "callnowDlg.h"

#include "vgClient.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCallnowDlg dialog

CCallnowDlg::CCallnowDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCallnowDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCallnowDlg)
	m_message = _T("");
	m_phone = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCallnowDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCallnowDlg)
	DDX_Text(pDX, IDC_MESSAGE, m_message);
	DDX_Text(pDX, IDC_PHONE, m_phone);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCallnowDlg, CDialog)
	//{{AFX_MSG_MAP(CCallnowDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CALLNOW, OnCallnow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCallnowDlg message handlers

BOOL CCallnowDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCallnowDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCallnowDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCallnowDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCallnowDlg::OnOK() 
{
	CDialog::OnOK();
}


void CCallnowDlg::GenerateVxml(FILE* fp, CString& msg)
{
	fprintf(fp, "<?xml version=\"1.0\"?>\r\n");
	fprintf(fp, "<vxml version=\"1.0\">\r\n");

	fprintf(fp, "<form id=\"cn\">\r\n");
	fprintf(fp, "  <block>\r\n");
	fprintf(fp, "    <audio src=\"callnow/hello.wav\"/>\r\n");
	fprintf(fp, msg);
	fprintf(fp, "  </block>\r\n");
	fprintf(fp, "</form>\r\n");

	fprintf(fp, "</vxml>\r\n");
}

void CCallnowDlg::OnCallnow() 
{
	UpdateData(true);

	// generate the vxml file
	FILE* fp = fopen("callnow.vxml", "w");
	if (fp == NULL) {
		AfxMessageBox("Cannot create file : callnow.vxml");
		return;
	}
	GenerateVxml(fp, m_message);
	fclose(fp);	

	// send the vxml file to gateway
	CString targetdir = "\\outcall\\webapps\\callnow\\";
	VgateClient::CreateDir(targetdir);
	if (! VgateClient::SendFile("callnow.vxml", targetdir + "\\callnow.vxml", false)) {
		AfxMessageBox(VgateClient::GetLastError());
		return;
	}

	// schedule the call
	CMapStringToString nvpairs;
	nvpairs["info"] = "CallNow Sample";
	nvpairs["phoneno"] = m_phone;
	nvpairs["firstocc"] = "10";
	nvpairs["startvxml"] = VgateClient::GetRemoteDir(targetdir) + "\\callnow.vxml";

	CString callId;
	if (! VgateClient::ScheduleCall(nvpairs, callId)) {
		AfxMessageBox(VgateClient::GetLastError());
		return;
	}

	// get the call status
	CPtrArray log;
	while (true) {
		Sleep(5000); // check every 5 seconds
		if (! VgateClient::GetCallStatus(callId, log, true)) {
			AfxMessageBox(VgateClient::GetLastError());
			return;
		}
		
		if (log.GetSize() == 0)
			continue; // still in progress

		VgateCallRecord* rec = (VgateCallRecord*) log.GetAt(log.GetSize() - 1);
		CString status;
		status.Format("Call status: %d %s", rec->m_status, rec->m_message);
		AfxMessageBox(status);
		break;
	}

	// clean up
	VgateClient::RemoveCall(callId);
	VgateClient::RemoveFile(targetdir + "\\callnow.vxml");
}




