/***************************************************************************
 * callpadDlg.cpp : implementation file
 *
 *  Copyright (c)2003 Voicent Communications, Inc, All Rights Reserved
 *  Voicent Product Support Services, Developer Support AutoReminder Integration
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 ***************************************************************************/

#include "stdafx.h"
#include "callpad.h"
#include "callpadDlg.h"
#include "afxinet.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCallpadDlg dialog

CCallpadDlg::CCallpadDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCallpadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCallpadDlg)
	m_msgId = _T("");
	m_phoneno = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCallpadDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCallpadDlg)
	DDX_Text(pDX, IDC_MSGID, m_msgId);
	DDX_Text(pDX, IDC_PHONENO, m_phoneno);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCallpadDlg, CDialog)
	//{{AFX_MSG_MAP(CCallpadDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CALL_NOW, OnCallNow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCallpadDlg message handlers

BOOL CCallpadDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCallpadDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCallpadDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCallpadDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



////////////////////////////////////////////////////////////////////////////////

// simple URLEncoding

static CString URLEncoding(CString ToCode)
{
    int max = (unsigned int)ToCode.GetLength();

    CString RetStr;
    for(int i=0;i<max;i++) {
        unsigned char c = ToCode[i];
        unsigned short asc = c;

        if(asc > 47 && asc < 58)
            RetStr += c;
        else if(asc > 64 && asc < 91)
            RetStr += c;
        else if(asc > 96 && asc < 123)
            RetStr+=c;
        else if (asc == 32)
            RetStr+="+";
        else {
			CString AddStr;
            AddStr.Format("%%%2x", asc);
            int iv = (int)AddStr.GetAt(1);
            if((int)AddStr.GetAt(1) == 32) {
                AddStr.SetAt(1,'0');
            }
            RetStr+=AddStr;
        }
    }

    return RetStr;
}

static BOOL PostToAutoReminder(const CString& poststr)
{
	CInternetSession sess;
	try {
		int appport = 80; // or whatever your set in AutoReminder
		CString urlstr = "/addHandler";

		CHttpConnection* conn = sess.GetHttpConnection("localhost", (INTERNET_PORT)appport);
		CHttpFile* pFile = conn->OpenRequest(CHttpConnection::HTTP_VERB_POST, urlstr);
		pFile->AddRequestHeaders("Content-Type: application/x-www-form-urlencoded\r\n");
		pFile->SendRequest(NULL, 0, (void*)(const char*)poststr, strlen(poststr));

		DWORD dwRet;
		pFile->QueryInfoStatusCode(dwRet);
		if (dwRet >= 300) {
			AfxMessageBox("Failed to connect to the AutoReminder. Make sure it is started.");
			delete conn;
			delete pFile;
			return false;
		}

		// parse return value
		CString strRetBufLen;
		pFile->QueryInfo(HTTP_QUERY_CONTENT_LENGTH, strRetBufLen);
		long max = atol((LPCSTR)strRetBufLen);
		if(max <= 0)
	        max = pFile->GetLength();

		// Read Data
		char buf[1024];
        int len = pFile->Read(buf, 1024);
		
		// ignored in this sample

		pFile->Close();
		conn->Close();
		delete pFile;
		delete conn;

		return true;
	}
	catch (CInternetException* ex) {
		char errbuf[1024];
		ex->GetErrorMessage(errbuf, 1024);
		AfxMessageBox(errbuf);
		ex->Delete();
		return false;
	}
}

static void SetCallParams(CString& poststr)
{
	// appointment date
	poststr += "&year=2004";
	poststr += "&month=dec";
	poststr += "&date=1";

	// appointment start and end time
	poststr += "&shour=" + URLEncoding("10 am");
	poststr += "&sminute=" + URLEncoding(":30");
	poststr += "&ehour=" + URLEncoding("11 am");
	poststr += "&eminute=" + URLEncoding(":30");

	// Text-to-speech
	CString mynotes = "Hello, how are you doing. This is fun.";
	poststr += "&notes=" + URLEncoding(mynotes);
	poststr += "&includenotes=on";

	// call now
	poststr += "&makecall=on";
	poststr += "&calltype=now";
}

void CCallpadDlg::OnCallNow() 
{
	UpdateData(true);

	CString poststr = "contact=" + URLEncoding("John Doe"); // or <My Self>
	poststr += "&phone=" + m_phoneno;

	// call message ID: Professional version only
	// otherwise, this value is default to system reminder message
	poststr += "&stdmsg=" + URLEncoding(m_msgId);

	SetCallParams(poststr);
	PostToAutoReminder(poststr);
}
