/***************************************************************************
 * cpp2Dlg.cpp
 *
 *  Copyright (c)2005 Voicent Communications, Inc, All Rights Reserved
 *  Voicent Product Support Services, Developer Support Tool Integration
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 ***************************************************************************/
#include "stdafx.h"
#include "cpp.h"
#include "cpp2Dlg.h"
#include "voicent.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// cpp2Dlg dialog


cpp2Dlg::cpp2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(cpp2Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(cpp2Dlg)
	m_ccode = _T("2345");
	m_vcastexe = _T("C:\\Program Files\\Voicent\\BroadcastByPhone\\bin\\vcast.exe");
	m_vocfile = _T("");
	m_wavfile = _T("C:\\Program Files\\Voicent\\MyRecordings\\sample_message.wav");
	//}}AFX_DATA_INIT
}


void cpp2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(cpp2Dlg)
	DDX_Text(pDX, IDC_CCODE, m_ccode);
	DDX_Text(pDX, IDC_VCASTEXE, m_vcastexe);
	DDX_Text(pDX, IDC_VOCFILE, m_vocfile);
	DDX_Text(pDX, IDC_WAVFILE, m_wavfile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(cpp2Dlg, CDialog)
	//{{AFX_MSG_MAP(cpp2Dlg)
	ON_BN_CLICKED(IDC_VCAST_BROWSE, OnVcastBrowse)
	ON_BN_CLICKED(IDC_VOC_BROWSE, OnVocBrowse)
	ON_BN_CLICKED(IDC_WAV_BROWSE, OnWavBrowse)
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// cpp2Dlg message handlers

void cpp2Dlg::OnVcastBrowse() 
{
	UpdateData(true);

	static char BASED_CODE szFilter[] = 
		"Exe File (*.exe)|*.exe|All Files (*.*)|*.*||";
	CFileDialog dlg(true, NULL, NULL, 0, szFilter);
	if (dlg.DoModal() != IDOK)
		return;

	m_vcastexe = dlg.GetPathName();
	UpdateData(false);	
}

void cpp2Dlg::OnVocBrowse() 
{
	UpdateData(true);

	static char BASED_CODE szFilter[] = 
		"BroadcastByPhone List File (*.voc)|*.voc|All Files (*.*)|*.*||";
	CFileDialog dlg(true, NULL, NULL, 0, szFilter);
	if (dlg.DoModal() != IDOK)
		return;

	m_vocfile = dlg.GetPathName();
	UpdateData(false);	
}

void cpp2Dlg::OnWavBrowse() 
{
	UpdateData(true);

	static char BASED_CODE szFilter[] = 
		"Audio File (*.wav)|*.wav|All Files (*.*)|*.*||";
	CFileDialog dlg(true, NULL, NULL, 0, szFilter);
	if (dlg.DoModal() != IDOK)
		return;

	m_wavfile = dlg.GetPathName();
	UpdateData(false);	
}

void cpp2Dlg::OnOK() 
{
	CDialog::OnOK();
}

void cpp2Dlg::OnStart() 
{
	UpdateData(true);

	Voicent voicent("localhost", 8155);

	voicent.CallTillConfirm(m_vcastexe, m_vocfile, m_ccode, m_wavfile);
}
