/***************************************************************************
 * cppDlg.cpp
 *
 *  Copyright (c)2005 Voicent Communications, Inc, All Rights Reserved
 *  Voicent Product Support Services, Developer Support Tool Integration
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 ***************************************************************************/
#include "stdafx.h"
#include "cpp.h"
#include "cppDlg.h"
#include "voicent.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCppDlg dialog

CCppDlg::CCppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCppDlg::IDD, pParent)
{
	m_filename = _T("");
	m_phoneno = _T("");
	m_reqId = _T("");
	m_text = _T("");
	m_text_or_audio = 0;
	m_status = _T("");
	m_appname = _T("");
	m_responses = _T("");

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pVoicent = new Voicent("localhost", 8155);
}

CCppDlg::~CCppDlg()
{
	delete m_pVoicent;
}

void CCppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_FILENAME, m_filename);
	DDX_Text(pDX, IDC_PHONENO, m_phoneno);
	DDX_Text(pDX, IDC_REQID, m_reqId);
	DDX_Text(pDX, IDC_TEXT_MSG, m_text);
	DDX_Radio(pDX, IDC_TEXT, m_text_or_audio);
	DDX_Text(pDX, IDC_STATUS, m_status);
	DDX_Text(pDX, IDC_MSGID, m_appname);
	DDX_Text(pDX, IDC_STATUS2, m_responses);
}

BEGIN_MESSAGE_MAP(CCppDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_CALL_NOW, OnCallNow)
	ON_BN_CLICKED(IDC_CALL_STATUS, OnCallStatus)
	ON_BN_CLICKED(IDC_CALL_REMOVE, OnCallRemove)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCppDlg message handlers

BOOL CCppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCppDlg::OnBrowse() 
{
	UpdateData(true);

	static char BASED_CODE szFilter[] = 
		"Audio File (*.wav)|*.wav|All Files (*.*)|*.*||";
	CFileDialog dlg(true, NULL, NULL, 0, szFilter);
	if (dlg.DoModal() != IDOK)
		return;

	m_filename = dlg.GetPathName();
	UpdateData(false);
}

void CCppDlg::OnCallNow() 
{
	UpdateData(true);

	if (m_phoneno.IsEmpty()) {
		AfxMessageBox("Please specify phone number");
		return;
	}

	if (m_text_or_audio == 0) // text
		m_reqId = m_pVoicent->CallText(m_phoneno, m_text);
	else if (m_text_or_audio == 1) // audio
		m_reqId = m_pVoicent->CallAudio(m_phoneno, m_filename);
	else // ivr
		m_reqId = m_pVoicent->CallIvr(m_phoneno, m_appname);

	m_status.Empty();
	m_responses.Empty();

	UpdateData(false);
}

void CCppDlg::OnCallStatus() 
{
	if (m_reqId.IsEmpty()) {
		AfxMessageBox("Call record reqId is empty. Please click Call Now first");
		return;
	}

	CMapStringToString responses;
	m_status = m_pVoicent->CallStatus(m_reqId, responses);

	POSITION pos = responses.GetStartPosition();
	while (pos != NULL) {
		CString key, value;
		responses.GetNextAssoc(pos, key, value);
		if (! m_responses.IsEmpty())
			m_responses += "; ";
		m_responses += key + "=" + value;
	}

	UpdateData(false);
}

void CCppDlg::OnCallRemove() 
{
	if (m_reqId.IsEmpty()) {
		AfxMessageBox("Call record reqId is empty. Please click Call Now first");
		return;
	}

	m_pVoicent->CallRemove(m_reqId);
	m_reqId.Empty();
	m_status.Empty();
	m_responses.Empty();

	UpdateData(false);	
}
