/***************************************************************************
 * voicent.cpp
 *
 *  Copyright (c)2003 Voicent Communications, Inc, All Rights Reserved
 *  Voicent Product Support Services, Developer Support AutoReminder Integration
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 ***************************************************************************/

#include "stdafx.h"
#include "afxinet.h"
#include "voicent.h"


////////////////////////////////////////////////////////////////////////////////
// Utility Routines

// simple URLEncoding

static CString URLEncode(CString ToCode)
{
    int max = (unsigned int)ToCode.GetLength();

    CString RetStr;
    for(int i=0;i<max;i++) {
        unsigned char c = ToCode[i];
        unsigned short asc = c;

        if(asc > 47 && asc < 58)
            RetStr += c;
        else if(asc > 64 && asc < 91)
            RetStr += c;
        else if(asc > 96 && asc < 123)
            RetStr+=c;
        else if (asc == 32)
            RetStr+="+";
        else {
			CString AddStr;
            AddStr.Format("%%%2x", asc);
            int iv = (int)AddStr.GetAt(1);
            if((int)AddStr.GetAt(1) == 32) {
                AddStr.SetAt(1,'0');
            }
            RetStr+=AddStr;
        }
    }

    return RetStr;
}

static BOOL PostToGateway(const char* host,			// host name
						  int port,					// port number
						  const CString& urlstr,	// call scheduler url
						  const CString& poststr,	// http post string
						  CString& rcstr)			// returned html page from gateway
{
	CInternetSession sess;
	try {
		CHttpConnection* conn = sess.GetHttpConnection(host, (INTERNET_PORT)port);
		CHttpFile* pFile = conn->OpenRequest(CHttpConnection::HTTP_VERB_POST, urlstr);
		pFile->AddRequestHeaders("Content-Type: application/x-www-form-urlencoded\r\n");
		pFile->SendRequest(NULL, 0, (void*)(const char*)poststr, strlen(poststr));

		DWORD dwRet;
		pFile->QueryInfoStatusCode(dwRet);
		if (dwRet >= 300) {
			rcstr = "Failed to connect to Voicent Gateway. Make sure it is started.";
			delete conn;
			delete pFile;
			return false;
		}

		// parse return value
		CString strRetBufLen;
		pFile->QueryInfo(HTTP_QUERY_CONTENT_LENGTH, strRetBufLen);
		ULONGLONG max = atol((LPCSTR)strRetBufLen);
		if(max <= 0)
	        max = pFile->GetLength();

		// Read Data
		char buf[1024];
        int len = pFile->Read(buf, 1024);
		rcstr = CString(buf, len);
		
		pFile->Close();
		conn->Close();
		delete pFile;
		delete conn;

		return true;
	}
	catch (CInternetException* ex) {
		char errbuf[1024];
		ex->GetErrorMessage(errbuf, 1024);
		rcstr = errbuf;
		ex->Delete();
		return false;
	}
}

// search for pattern [ReqId=*]
static CString GetReqId(const CString& rcstr)
{
	int index1 = rcstr.Find("[ReqId=");
	if (index1 == -1)
		return "";
	index1 += 7;

	int index2 = rcstr.Find("]", index1);
	if (index2 == -1)
		return "";

	return rcstr.Mid(index1, index2 - index1);
}

// search for pattern ^made^ or ^failed^
static CString GetCallStatus(const CString& rcstr)
{
	if (rcstr.Find("^made^") != -1)
		return "Call Made";

	if (rcstr.Find("^failed^") != -1)
		return "Call Failed";

	if (rcstr.Find("^retry^") != -1)
		return "Call Will Retry";

	return "";
}

static void ParseCallResponses(CString& respstr, CMapStringToString& responses)
{
	while (! respstr.IsEmpty()) {
		int index = respstr.Find('|');
		CString nvstr = respstr;
		if (index != -1)
			nvstr = respstr.Left(index).Trim();

		int index2 = nvstr.Find('=');
		if (index2 == -1)
			responses["__response___"] = nvstr;
		else {
			CString key = nvstr.Left(index2).Trim();
			CString value = nvstr.Mid(index2+1).Trim();
			responses.SetAt(key, value);
		}

		if (index == -1)
			break;
		respstr = respstr.Mid(index+1).Trim();
	}
}

// the confirmation string is returned as the 7th string between ^
// please note that this format and location is pretty stable from release to release
// however, it is not guaranteed to be fixed. If you want develop your code independent of
// the changes, you can get Voicent gateway client library that is included in the Developer Subscription

static CString GetCallStatus(const CString& rcstr, CMapStringToString& responses)
{
	responses.RemoveAll();

	int startIndex = 0;
	for (int i = 0; i <= 7; i++) {
		int index = rcstr.Find('^', startIndex);
		if (index == -1)
			break;
		startIndex = index + 1;
		if (i < 7)
			continue;

		CString respstr = rcstr.Mid(startIndex);
		index = respstr.Find('^');
		if (index != -1)
			respstr = respstr.Left(index);
		respstr.Trim();

		ParseCallResponses(respstr, responses);
	}

	return GetCallStatus(rcstr);
}



////////////////////////////////////////////////////////////////////////////////
// Voicent

Voicent::Voicent(const char* host, int port)
{
	m_host = host;
	m_port = port;
}

Voicent::~Voicent()
{
}


// Please refer to http://www.voicent.com/devnet/docs/simpleintf.htm
// for detailed information on these parameters

CString Voicent::CallText(const char* phoneno, const char* text, BOOL selfDelete)
{
	// call request url
	CString urlstr = "/ocall/callreqHandler.jsp";

	// setting the http post string
	CString poststr;
	
	poststr += "info=";
	poststr += URLEncode(CString("Simple Text Call ") + phoneno);

	poststr += "&phoneno=";
	poststr += phoneno;

	poststr += "&firstocc=10";

	poststr += "&selfdelete=";
	poststr += (selfDelete ? "1" : "0");

	poststr += "&txt=";
	poststr += URLEncode(text);

	// Send Call Request
	CString rcstr;
	if (! PostToGateway(m_host, m_port, urlstr, poststr, rcstr))
		return "";

	return GetReqId(rcstr);
}

CString Voicent::CallAudio(const char* phoneno, const char* audiofile, BOOL selfDelete)
{
	// call request url
	CString urlstr = "/ocall/callreqHandler.jsp";

	// setting the http post string
	CString poststr;
	
	poststr += "info=";
	poststr += URLEncode(CString("Simple Audio Call ") + phoneno);

	poststr += "&phoneno=";
	poststr += phoneno;

	poststr += "&firstocc=10";

	poststr += "&selfdelete=";
	poststr += (selfDelete ? "1" : "0");

	poststr += "&audiofile=";
	poststr += URLEncode(audiofile);

	// Send Call Request
	CString rcstr;
	if (! PostToGateway(m_host, m_port, urlstr, poststr, rcstr))
		return "";

	return GetReqId(rcstr);
}

CString Voicent::CallIvr(const char* phoneno, const char* appname, BOOL selfDelete)
{
	// call request url
	CString urlstr = "/ocall/callreqHandler.jsp";

	// setting the http post string
	CString poststr;
	
	poststr += "info=";
	poststr += URLEncode(CString("Simple IVR Call ") + phoneno);

	poststr += "&phoneno=";
	poststr += phoneno;

	poststr += "&firstocc=10";

	poststr += "&selfdelete=";
	poststr += (selfDelete ? "1" : "0");

	poststr += "&startapp=";
	poststr += URLEncode(appname);

	// Send Call Request
	CString rcstr;
	if (! PostToGateway(m_host, m_port, urlstr, poststr, rcstr))
		return "";

	return GetReqId(rcstr);
}

CString Voicent::CallStatus(const char* reqId)
{
	// call status url
	CString urlstr = "/ocall/callstatusHandler.jsp";

	// setting the http post string
	CString poststr = "reqid=";
	poststr += URLEncode(reqId);

	// Send Call Request
	CString rcstr;
	if (! PostToGateway(m_host, m_port, urlstr, poststr, rcstr))
		return "";

	return GetCallStatus(rcstr);
}

CString Voicent::CallStatus(const char* reqId, CMapStringToString& responses)
{
	// call status url
	CString urlstr = "/ocall/callstatusHandler.jsp";

	// setting the http post string
	CString poststr = "reqid=";
	poststr += URLEncode(reqId);

	// Send Call Request
	CString rcstr;
	if (! PostToGateway(m_host, m_port, urlstr, poststr, rcstr))
		return "";

	return GetCallStatus(rcstr, responses);
}

void Voicent::CallRemove(const char* reqId)
{
	// call status url
	CString urlstr = "/ocall/callremoveHandler.jsp";

	// setting the http post string
	CString poststr = "reqid=";
	poststr += URLEncode(reqId);

	// Send Call Request
	CString rcstr;
	PostToGateway(m_host, m_port, urlstr, poststr, rcstr);
}

// Call scheduler can launch program also
void Voicent::CallTillConfirm(const char* vcastexe,
		                      const char* vocfile,
					          const char* ccode,
					          const char* wavfile)
{
	// call request url
	CString urlstr = "/ocall/callreqHandler.jsp";

	// setting the http post string
	CString poststr;
	
	poststr += "info=";
	poststr += URLEncode("Simple Call till Confirm");

	poststr += "&phoneno=1111111"; // any number

	poststr += "&firstocc=10";
	poststr += "&selfdelete=0";

	poststr += "&startexec=";
	poststr += URLEncode(vcastexe);

	CString cmdline;
	cmdline  = "\"";
	cmdline += vocfile;
	cmdline += "\"";
	cmdline += " -startnow";
	cmdline += " -confirmcode ";
	cmdline += ccode;
	cmdline += " -wavfile ";
	cmdline += "\"";
	cmdline += wavfile;
	cmdline += "\"";

	// add -cleanstatus if necessary

	poststr += "&cmdline=";
	poststr += URLEncode(cmdline);

	// Send Call Request
	CString rcstr;
	PostToGateway(m_host, m_port, urlstr, poststr, rcstr);
}




