/***************************************************************************
 * voicent.h
 *
 *  Copyright (c)2005 - 2011 Voicent Communications, Inc, All Rights Reserved
 *  Voicent Product Support Services, Developer Support Tool Integration
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 *  EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 ***************************************************************************/
#ifndef VOICENT_H_INCLUDED
#define VOICENT_H_INCLUDED


class Voicent
{
public:
	Voicent(const char* host, int port);
	~Voicent();

	// ** Standard Operations **

	// Call Request. Return reqId of this call record on the gateway

	CString CallText(const char* phoneno,		// phone number
		             const char* text,			// text message using text-to-speech
					 BOOL selfDelete = false);	// delete call record after call made

	// Call Request. Return reqId of this call record on the gateway

	CString CallAudio(const char* phoneno,		// phone number
		              const char* wavfile,		// audio file to play (PCM 16bit, 8KHz, mono)
					  BOOL selfDelete = false);	// delete call record after call made

	// Get call status

	CString CallStatus(const char* reqId);		// Call record reqId

	// Remove call record

	void CallRemove(const char* reqId);			// Call record ReqId

	// ** BroadcastByPhone **

	// Invoke BroadcastByPhone
	void CallTillConfirm(const char* vcastexe,	// BroadcastByPhone executable path
		                 const char* vocfile,	// Broadcast file
						 const char* ccode,		// confirmation code
						 const char* wavfile);	// audio file (PCM 16bit, 8KHz, mono)

	// ** extended simple call interface for using with IVR Studio

	// Call Request. Return reqId of this call record on the gateway
	
	CString CallIvr(const char* phoneno,		// phone number
					const char* appname,		// deployed IVR app name
					BOOL selfDelete = false);	// delete call record after call made

	// get call status and save responses in responses
	CString CallStatus(const char* reqId,				// Call record reqId
					   CMapStringToString& responses);	// name value pairs of responses, name is the IVR element name

private:
	CString m_host;
	int     m_port;
};


#endif
