/*
 * Decompiled with CFR 0.152.
 */
package vx.apps.email;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;

public class EmailMessageReader {
    protected Message msg_ = null;
    protected String newContent_ = null;
    protected String oldContent_ = null;
    protected Part[] includes_ = null;

    public EmailMessageReader() {
        this.msg_ = null;
    }

    public EmailMessageReader(Message message) throws IOException, MessagingException {
        this.msg_ = message;
        this.setMessage(message);
    }

    public void setMessage(Message message) throws IOException, MessagingException {
        this.msg_ = message;
        String string = this.getContent();
        if (string == null) {
            this.newContent_ = null;
            this.oldContent_ = null;
        } else {
            int n = string.indexOf("----- Original Message -----");
            this.newContent_ = string;
            this.oldContent_ = null;
            if (n != -1) {
                this.newContent_ = string.substring(0, n);
                this.oldContent_ = string.substring(n);
            }
        }
        ArrayList arrayList = this.collectFiles();
        if (arrayList.size() == 0) {
            this.includes_ = null;
        } else {
            this.includes_ = new Part[arrayList.size()];
            arrayList.toArray(this.includes_);
        }
    }

    public String getFrom() throws MessagingException {
        return EmailMessageReader.getFrom(this.msg_);
    }

    public static String getFrom(Message message) throws MessagingException {
        Address[] addressArray = message.getFrom();
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < addressArray.length; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            String string2 = addressArray[i].toString();
            string = string + EmailMessageReader.removeChars(string2);
        }
        return string;
    }

    public String getRecipients() throws MessagingException {
        return EmailMessageReader.getRecipients(this.msg_);
    }

    public static String getRecipients(Message message) throws MessagingException {
        Address[] addressArray = message.getRecipients(Message.RecipientType.TO);
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < addressArray.length; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            String string2 = addressArray[i].toString();
            string = string + EmailMessageReader.removeChars(string2);
        }
        return string;
    }

    public String getDate() throws MessagingException {
        return EmailMessageReader.getDate(this.msg_);
    }

    public static String getDate(Message message) throws MessagingException {
        Date date = message.getSentDate();
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d hh:mm aa");
            return simpleDateFormat.format(date);
        }
        return null;
    }

    public static boolean isMultipart(Part part) throws MessagingException {
        return part.isMimeType("multipart/*");
    }

    public static boolean isWave(Part part) throws MessagingException {
        return part.isMimeType("audio/x-wav") || part.isMimeType("audio/wav");
    }

    public static boolean isText(Part part) throws MessagingException {
        return part.isMimeType("text/plain");
    }

    public static String readWaveFile(Part part, File file) throws IOException, MessagingException {
        int n;
        InputStream inputStream = part.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        return part.getFileName();
    }

    public ArrayList collectFiles() throws IOException, MessagingException {
        return this.collectFiles((Part)this.msg_);
    }

    public ArrayList collectFiles(Part part) throws IOException, MessagingException {
        ArrayList<Part> arrayList = new ArrayList<Part>();
        if (part.getFileName() != null) {
            arrayList.add(part);
            return arrayList;
        }
        if (EmailMessageReader.isMultipart(part)) {
            Multipart multipart = (Multipart)part.getContent();
            for (int i = 0; i < multipart.getCount(); ++i) {
                arrayList.addAll(this.collectFiles((Part)multipart.getBodyPart(i)));
            }
        }
        return arrayList;
    }

    public String includeContent() throws IOException, MessagingException {
        return EmailMessageReader.includeContent((Part)this.msg_);
    }

    public static String includeContent(Part part) throws IOException, MessagingException {
        StringBuffer stringBuffer;
        block3: {
            String string;
            block2: {
                stringBuffer = new StringBuffer();
                if (!EmailMessageReader.isMultipart(part)) break block2;
                Multipart multipart = (Multipart)part.getContent();
                for (int i = 0; i < multipart.getCount(); ++i) {
                    stringBuffer.append(EmailMessageReader.includeContent((Part)multipart.getBodyPart(i)));
                    stringBuffer.append("\n");
                }
                break block3;
            }
            if (!EmailMessageReader.isText(part) || part.getFileName() != null) break block3;
            BufferedReader bufferedReader = new BufferedReader(new StringReader((String)part.getContent()));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(">");
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getContent() throws IOException, MessagingException {
        return EmailMessageReader.getContent((Part)this.msg_);
    }

    public static String getContent(Part part) throws IOException, MessagingException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (EmailMessageReader.isText(part)) {
            stringBuffer.append((String)part.getContent());
        } else if (EmailMessageReader.isMultipart(part)) {
            object = (Multipart)part.getContent();
            int n = object.getCount();
            for (int i = 0; i < n; ++i) {
                String string;
                BodyPart bodyPart = object.getBodyPart(i);
                if (bodyPart.getFileName() != null || (string = EmailMessageReader.getContent((Part)bodyPart)) == null) continue;
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        } else if (part.isMimeType("message/rfc822") && (object = EmailMessageReader.getContent((Part)part.getContent())) != null) {
            stringBuffer.append((String)object);
        }
        object = EmailMessageReader.removeChars(stringBuffer.toString());
        if (object.trim().length() == 0) {
            return null;
        }
        return object;
    }

    public static String[] breakup(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while (string.length() > 0) {
            if (string.length() < 400) {
                arrayList.add(string);
                break;
            }
            for (int i = 320; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '\n' && i != string.length() - 1 && (c != '.' || string.charAt(i + 1) != ' ')) continue;
                arrayList.add(string.substring(0, i + 1));
                string = string.substring(i + 1);
                continue block0;
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getNewContent() {
        return this.newContent_;
    }

    public String getOldContent() {
        return this.oldContent_;
    }

    public Part getIncludeFile(int n) {
        if (this.includes_ == null) {
            return null;
        }
        if (n >= this.includes_.length || n < 0) {
            return null;
        }
        return this.includes_[n];
    }

    public int numIncludeFiles() {
        if (this.includes_ == null) {
            return 0;
        }
        return this.includes_.length;
    }

    public static String filterChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append(" less than ");
                continue;
            }
            if (c == '>') {
                stringBuffer.append(" greater than ");
                continue;
            }
            if (c == '\'' || c == '\"') {
                stringBuffer.append(" quote ");
                continue;
            }
            if (c == '&') {
                stringBuffer.append(" and ");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String removeChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<' || c == '>' || c == '\'' || c == '\"' || c == '&') {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

