<?xml version="1.0"?>
<vxml version="1.0">

<%@ page import="java.util.Date" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="java.util.TimeZone" %>
<%@ page import="java.io.*" %> 
<%  
    response.setHeader("Cache-Control","no-cache");
    
    Date d = new Date(System.currentTimeMillis());
    
    String tz = request.getParameter("tz");
    TimeZone timez = null;
    if ("1".equals(tz) || "pacific time".equals(tz))
        timez = TimeZone.getTimeZone("America/Los_Angeles");
    else if ("2".equals(tz) || "mountain time".equals(tz))
        timez = TimeZone.getTimeZone("America/Denver");
    else if ("3".equals(tz) || "central time".equals(tz))
        timez = TimeZone.getTimeZone("America/Chicago");
    else if ("4".equals(tz) || "eastern time".equals(tz))
        timez = TimeZone.getTimeZone("America/New_York");   
    
    SimpleDateFormat f; 
    if (timez != null) {
        f = new SimpleDateFormat("hh:mm a, zzzz");
        f.setTimeZone(timez);
    }
    else {
        f = new SimpleDateFormat("hh:mm a");
    }
  
    boolean useVcmd = false;
    try {
        String webappDir = application.getRealPath("/");
        FileReader fr = new FileReader(webappDir + "/setup.txt");
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        if ("yes".equals(line))
            useVcmd = true;
    }
    catch (IOException e) {
    }
%>

<form id="td">
  <field name="tz">
    <prompt timeout="10s">
      <block>
        <audio src="audio/welcome.wav"/>
        <%= f.format(d) %>
        <% if (useVcmd) { %>
            <audio src="audio/which_timezone.wav"/>
        <% } else { %>
            <audio src="audio/which_timezone_dtmf.wav"/>
        <% } %>
      </block>
    </prompt> 
    <% if (useVcmd) { %>
        <grammar>
          pacific time | mountain time | central time | eastern time
        </grammar>
    <% } else { %>
        <dtmf>
          1 | 2 | 3 | 4
        </dtmf>
    <% } %>
    <filled>
      <submit next="/td/timeofday.jsp" namelist="tz"/>
    </filled>
  </field>
</form> 
</vxml> 
