<?PHP
    class Auth
    {
        const SALT = 'BroacastByEmail Web module: insert some random text here';

        private static $inst;

        public $username;
        public $expiryDate;
        private $loggedIn;
        

        public function __construct()
        {
            $this->username   = null;
            $this->loggedIn   = false;
            $this->expiryDate = time()+3600; //mktime(0, 0, 0, 6, 2, 2037);
        }

        public static function getAuth()
        {
            if(is_null(self::$inst))
            {
                self::$inst = new Auth();
                self::$inst->init();
            }
            return self::$inst;
        }

        public function init()
        {
            $this->setAccessCookie();
            $this->loggedIn = $this->cookieLogin();
        }

        public function login($username, $password)
        {
            $this->loggedIn = false;

            $db = Database::getDatabase();
            $row = $db->getRow("SELECT * FROM bbe_admin WHERE opt_name = 'bbe user'");
            if ($row === false || $row['opt_value'] != $username)
                return false;
            
            $row = $db->getRow("SELECT * FROM bbe_admin WHERE opt_name = 'bbe pass'");
            if ($row === false || $row['opt_value'] != $password)
                return false;

            $this->username = $username;

            $this->generateBCCookies();

            $this->loggedIn = true;

            return true;
        }

        public function logout()
        {
            $this->loggedIn = false;
            $this->clearCookies();
        }

        public function loggedIn()
        {
            return $this->loggedIn;
        }

        private function cookieLogin()
        {
            if(!isset($_COOKIE['ACC']) || !isset($_COOKIE['B']) || !isset($_COOKIE['C']))
                return false;

            $ccookie = base64_decode(str_rot13($_COOKIE['C']));
            if($ccookie === false)
                return false;

            $c = array();
            parse_str($ccookie, $c);
            if(! isset($c['l']))
                return false;

            $bcookie = base64_decode(str_rot13($_COOKIE['B']));
            if($bcookie === false)
                return false;

            $b = array();
            parse_str($bcookie, $b);
            if(!isset($b['s']) || !isset($b['x']))
                return false;

            if($b['x'] < time())
                return false;

            $computed_sig = md5(str_rot13(base64_encode($ccookie)) . $b['x'] . self::SALT);
            if($computed_sig != $b['s'])
                return false;

            $db = Database::getDatabase();

            // We SELECT * so we can load the full user record into the user DBObject later
            $row = $db->getRow("SELECT * FROM bbe_admin WHERE opt_name = 'bbe user'");
            if($row === false)
                return false;

            $this->username = $row['opt_value'];

            return true;
        }

        private function setAccessCookie()
        {
            if(! isset($_COOKIE['ACC'])) {
                srand(time());
                $a = md5(rand() . microtime());
                setcookie('ACC', $a, $this->expiryDate,  '/', Config::get('authDomain'));
            }
        }

        private function generateBCCookies()
        {
            $c  = '';
            $c .= 'l=' . str_rot13($this->username) . '&';
            $c = base64_encode($c);
            $c = str_rot13($c);

            $sig = md5($c . $this->expiryDate . self::SALT);
            $b = "x={$this->expiryDate}&s=$sig";
            $b = base64_encode($b);
            $b = str_rot13($b);

            setcookie('B', $b, $this->expiryDate, '/', Config::get('authDomain'));
            setcookie('C', $c, $this->expiryDate, '/', Config::get('authDomain'));
        }

        private function clearCookies()
        {
            setcookie('B', '', time() - 3600, '/', Config::get('authDomain'));
            setcookie('C', '', time() - 3600, '/', Config::get('authDomain'));
        }
    }