<?PHP
    class Database
    {
        private static $inst;

		public $dbconn;
		
        public $host;
        public $name;
        public $username;
        public $password;

        public $queries;
        public $result;


        private function __construct()
        {
            $this->host      = Config::get('dbHost');
            $this->name      = Config::get('dbName');
            $this->username  = Config::get('dbUsername');
            $this->password  = Config::get('dbPassword');
            $this->onError   = Config::get('dbOnError');
            
            $this->dbconn = false;
            $this->queries = array();
        }

        public static function getDatabase()
        {
            if(is_null(self::$inst))
                self::$inst = new Database();
            return self::$inst;
        }

        public function isConnected()
        {
            return is_resource($this->dbconn) && get_resource_type($this->dbconn) == 'mysql link';
        }

        public function databaseSelected()
        {
            if(!$this->isConnected()) return false;
            $result = mysql_list_tables($this->name, $this->dbconn);
            return is_resource($result);
        }

        public function connect()
        {
            $this->dbconn = mysql_connect($this->host, $this->username, $this->password) or $this->notify();
            if($this->dbconn === false) return false;

            if(!empty($this->name))
                mysql_select_db($this->name, $this->dbconn) or $this->notify();

            return $this->isConnected();
        }

        public function query($sql, $args_to_prepare = null, $exception_on_missing_args = true)
        {
            $sql = trim($sql);
            
            if(! $this->isConnected())
                $this->connect();
            
            // Allow for prepared arguments. Example:
            // query("SELECT * FROM table WHERE id = :id:", array('id' => $some_val));
            
            if(is_array($args_to_prepare))
            {
                foreach($args_to_prepare as $name => $val)
                {
					if(!is_int($val)) $val = $this->quote($val);
                    $sql = str_replace(":$name:", $val, $sql, $count);
                    if($exception_on_missing_args && (0 == $count))
                        throw new Exception(":$name: was not found in prepared SQL query.");
                }
            }

            $this->queries[] = $sql;
            $this->result = mysql_query($sql, $this->dbconn) or $this->notify();
            return $this->result;
        }

        // Returns the number of rows.
        // You can pass in nothing, a string, or a db result
        public function numRows($arg = null)
        {
            $result = $this->resulter($arg);
            return ($result !== false) ? mysql_num_rows($result) : false;
        }

        // Returns true / false if the result has one or more rows
        public function hasRows($arg = null)
        {
            $result = $this->resulter($arg);
            return is_resource($result) && (mysql_num_rows($result) > 0);
        }

        // Returns the number of rows affected by the previous WRITE operation
        public function affectedRows()
        {
            if(!$this->isConnected()) return false;
            return mysql_affected_rows($this->dbconn);
        }

        // Returns the auto increment ID generated by the previous insert statement
        public function insertId()
        {
            if(!$this->isConnected()) return false;
            return mysql_insert_id($this->dbconn);
        }

        // Returns a single value.
        // You can pass in nothing, a string, or a db result
        public function getValue($arg = null)
        {
            $result = $this->resulter($arg);
            return $this->hasRows($result) ? mysql_result($result, 0, 0) : false;
        }

        // Returns an array of the first value in each row.
        // You can pass in nothing, a string, or a db result
        public function getValues($arg = null)
        {
            $result = $this->resulter($arg);
            if(!$this->hasRows($result)) return array();

            $values = array();
            mysql_data_seek($result, 0);
            while($row = mysql_fetch_array($result, MYSQL_ASSOC))
                $values[] = array_pop($row);
            return $values;
        }

        // Returns the first row.
        // You can pass in nothing, a string, or a db result
        public function getRow($arg = null)
        {
            $result = $this->resulter($arg);
            return $this->hasRows($result) ? mysql_fetch_array($result, MYSQL_ASSOC) : false;
        }

        // Returns an array of all the rows.
        // You can pass in nothing, a string, or a db result
        public function getRows($arg = null)
        {
            $result = $this->resulter($arg);
            if(!$this->hasRows($result)) return array();

            $rows = array();
            mysql_data_seek($result, 0);
            while($row = mysql_fetch_array($result, MYSQL_ASSOC))
                $rows[] = $row;
            return $rows;
        }

        // Escapes a value and wraps it in single quotes.
        public function quote($var)
        {
            return "'" . $this->escape($var) . "'";
        }

        // Escapes a value.
        public function escape($var)
        {
            if(!$this->isConnected()) $this->connect();
            return mysql_real_escape_string($var, $this->dbconn);
        }

        public function numQueries()
        {
            return count($this->queries);
        }

        public function lastQuery()
        {
            if($this->numQueries() > 0)
                return $this->queries[$this->numQueries() - 1];
            else
                return false;
        }
        
        public function isTableCreated($tableName)
        {
        	$sqlst = "SHOW TABLES WHERE Tables_in_" . $this->name . " = '" . $tableName . "'";
        	$result = $this->query($sqlst);
			return $this->hasRows($result);
        }

        private function notify()
        {
            echo "<p style='border:5px solid red;background-color:#fff;padding:5px;'><strong>Read Database Error:</strong><br/>" . mysql_error($this->dbconn) . "</p>";
            echo "<p style='border:5px solid red;background-color:#fff;padding:5px;'><strong>Last Query:</strong><br/>" . $this->lastQuery() . "</p>";
            echo "<pre>";
            debug_print_backtrace();
            echo "</pre>";
            exit;
        }

        // Takes nothing, a MySQL result, or a query string and returns
        // the correspsonding MySQL result resource or false if none available.
        private function resulter($arg = null)
        {
            if(is_null($arg) && is_resource($this->result))
                return $this->result;
            elseif(is_resource($arg))
                return $arg;
            elseif(is_string($arg))
            {
                $this->query($arg);
                if(is_resource($this->result))
                    return $this->result;
                else
                    return false;
            }
            else
                return false;
        }
    }