<?PHP
    class DBSession
    {
        public static function register()
        {
            ini_set('session.save_handler', 'user');
            session_set_save_handler(array('DBSession', 'open'), array('DBSession', 'close'), array('DBSession', 'read'), array('DBSession', 'write'), array('DBSession', 'destroy'), array('DBSession', 'gc'));
        }

        public static function open()
        {
            $db = Database::getDatabase();
            return $db->isConnected();
        }

        public static function close()
        {
            return true;
        }

        public static function read($id)
        {
            $db = Database::getDatabase();
            $db->query("SELECT * FROM bbe_admin WHERE opt_name = 'bbe session'");
            return $db->hasRows() ? $db->getValue() : '';
        }

        public static function write($id, $data)
        {
            $db = Database::getDatabase();
            $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe session'");
            $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe sesstime'");
            $db->query("INSERT INTO `bbe_admin` VALUES ('bbe session', :data:)", array('data' => $data));
            $db->query("INSERT INTO `bbe_admin` VALUES ('bbe sesstime', :sesstime:)", array('sesstime' => time()));
            return ($db->affectedRows() == 2);
        }

        public static function destroy($id)
        {
            $db = Database::getDatabase();
            $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe session'");
            $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe sesstime'");
            return ($db->affectedRows() == 2);
        }

        public static function gc($max)
        {
            $db = Database::getDatabase();
            $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe sesstime' AND `opt_value` < :sesstime:", array('sesstime' => time() - $max));
            if ($db->affectedRows() == 1)
                $db->query("DELETE FROM `bbe_admin` WHERE `opt_name` = 'bbe session'");
            return true;
        }
    }