<?php

class Opentrack
{
    public $eid;
    public $ipaddr;
    public $atime;
    
    public function __construct()
    {
        $this->eid = null;
        $this->ipaddr = null;
    }
    
    public static function count($eid)
    {
        $db = Database::getDatabase();
        $result = $db->query("SELECT count(*) as amount FROM bbe_opentrack WHERE eid = :eid:", array('eid'=>$eid));
        if ($db->hasRows()) {
            $row = $db->getRow($result);
            return $row['amount'];
        }
        return 0;
    }
    
    public static function save($track)
    {
        if ($track == null || $track->eid == null)
            return;
        
        $db = Database::getDatabase();
        $db->query("INSERT INTO bbe_opentrack VALUES (:eid:, :ip:, now())", array('eid'=>$track->eid, 'ip'=>$track->ipaddr));
    }
    
    public static function find($eid, $track)
    {
        $db = Database::getDatabase();
        $result = $db->query("SELECT * FROM bbe_opentrack WHERE eid = :eid:", array('eid'=>$eid));
        if (! $db->hasRows())
            return false;
        
        $row = $db->getRow($result);
        $track->eid = $row['eid'];
        $track->ip = $row['ipaddr'];
        $track->atime = $row['atime'];
        return true;
    }
    
    public static function fetchAll()
    {
        $db = Database::getDatabase();
        $rows = $db->query("SELECT * FROM bbe_opentrack");
        
        $entries = array();
        while($row = mysql_fetch_array($rows, MYSQL_ASSOC)) {
            $track = new Opentrack();
            $track->eid = $row['eid'];
            $track->ip = $row['ipaddr'];
            $track->atime = $row['atime'];
            $entries[] = $track;
        }
        return $entries;
    }
    
    public static function fetch($page, $count)
    {
        $db = Database::getDatabase();
        $rows = $db->query("SELECT * FROM bbe_opentrack LIMIT " . $page * $count . ", " . $count);
        
        $entries = array();
        while($row = mysql_fetch_array($rows, MYSQL_ASSOC)) {
            $track = new Opentrack();
            $track->eid = $row['eid'];
            $track->ip = $row['ipaddr'];
            $track->atime = $row['atime'];
            $entries[] = $track;
        }
        return $entries;
    }
    
    public static function delete($eid)
    {
        if ($eid == null || $eid == '')
            return;
        
        $db = Database::getDatabase();
        $db->query("DELETE FROM bbe_opentrack WHERE eid = :eid:", array('eid'=>$eid));
    }
}

?>
