<?php

class Subscriber
{
    public $email_addr;
    public $sub_date;
    
    public function __construct()
    {
        $this->email_addr = null;
        $this->sub_date = null;
    }
    
    public static function count()
    {
        $db = Database::getDatabase();
        $result = $db->query("SELECT count(*) as amount FROM bbe_subscriber");
        if ($db->hasRows()) {
            $row = $db->getRow($result);
            return $row['amount'];
        }
        return 0;
    }
    
    public static function save($sub)
    {
        if ($sub == null || $sub->email_addr == null)
            return;
        
        $db = Database::getDatabase();
        
        $subdate = $sub->sub_date;
        if ($subdate == null)
            $subdate = date('Y-m-d');
        
        $db->query("INSERT INTO bbe_subscriber VALUES (:email:, :date:)", array('email'=>$sub->email_addr, 'date'=>$subdate));
    }
    
    public static function find($emailaddr, $sub)
    {
        $db = Database::getDatabase();
        $result = $db->query("SELECT * FROM bbe_subscriber WHERE email_addr = :email:", array('email'=>$emailaddr));
        if (! $db->hasRows())
            return false;
        
        $row = $db->getRow($result);
        $sub->email_addr = $row['email_addr'];
        $sub->sub_date = $row['sub_date'];
        return true;
    }
    
    public static function fetchAll()
    {
        $db = Database::getDatabase();
        $rows = $db->query("SELECT * FROM bbe_subscriber");
        
        $entries = array();
        while($row = mysql_fetch_array($rows, MYSQL_ASSOC)) {
            $entry = new Subscriber();
            $entry->email_addr = $row['email_addr'];
            $entry->sub_date = $row['sub_date'];
            $entries[] = $entry;
        }
        return $entries;
    }
    
    public static function fetch($page, $count)
    {
        $db = Database::getDatabase();
        $rows = $db->query("SELECT * FROM bbe_subscriber LIMIT " . $page * $count . ", " . $count);
        
        $entries = array();
        while($row = mysql_fetch_array($rows, MYSQL_ASSOC)) {
            $entry = new Subscriber();
            $entry->email_addr = $row['email_addr'];
            $entry->sub_date = $row['sub_date'];
            $entries[] = $entry;
        }
        return $entries;
    }
    
    public static function delete($emailaddr)
    {
        if ($emailaddr == null || $emailaddr == '')
            return;
        
        $db = Database::getDatabase();
        $rows = $db->query("DELETE FROM bbe_subscriber WHERE email_addr = :email:", array('email'=>$emailaddr));
    }
}

?>
