<?PHP

    function redirect($url = null)
    {
        if(is_null($url)) $url = $_SERVER['PHP_SELF'];
        header("Location: $url");
        exit();
    }

    function fix_slashes($arr = '')
    {
        if (is_null($arr) || $arr == '')
        	return null;
        	
        if (!get_magic_quotes_gpc())
        	return $arr;
        	
        return is_array($arr) ? array_map('fix_slashes', $arr) : stripslashes($arr);
    }
    

    spl_autoload_register('autoload_class');

    function autoload_class($class_name)
    {
        $filename = DOC_ROOT . '/includes/class.' . strtolower($class_name) . '.php';
        if(file_exists($filename))
            require $filename;
    }