<?php
	
    date_default_timezone_set('America/Los_Angeles');

    define('DOC_ROOT', realpath(dirname(__FILE__)));
    require DOC_ROOT . '/includes/load.inc.php';

    if(get_magic_quotes_gpc()) {
        $_POST    = fix_slashes($_POST);
        $_GET     = fix_slashes($_GET);
        $_REQUEST = fix_slashes($_REQUEST);
        $_COOKIE  = fix_slashes($_COOKIE);
    }

    $Config = Config::getConfig();
	
	$msg = '';
	
	$db = Database::getDatabase();
	if ($db->isTableCreated('bbe_admin')) {
		$msg = 'It appears that this module has been installed already';
	}
	else if (isset($_POST['install'])) {
		$adminname = $_POST['name'];
		$passwd = $_POST['passwd'];
		if ($adminname == '' || $passwd == '') {
			$msg = 'Admin name or password cannot be empty';
		}
		else {
			$db->query("CREATE TABLE IF NOT EXISTS `bbe_admin` (`opt_name` varchar(32) NOT NULL, `opt_value` varchar(255) DEFAULT NULL, PRIMARY KEY (`opt_name`))");
			$db->query("CREATE TABLE IF NOT EXISTS `bbe_noemail` (`email_addr` varchar(128) NOT NULL DEFAULT '', `dne_reason` enum('Unsubscribe','Bounced') NOT NULL, PRIMARY KEY (`email_addr`))");
			$db->query("CREATE TABLE IF NOT EXISTS `bbe_opentrack` (`eid` varchar(64) NOT NULL DEFAULT '', `ipaddr` varchar(16) NOT NULL DEFAULT '', `atime` timestamp NOT NULL, PRIMARY KEY (`eid`))");
			$db->query("CREATE TABLE IF NOT EXISTS `bbe_subscriber` (`email_addr` varchar(64) NOT NULL DEFAULT '', `sub_date` date DEFAULT NULL, PRIMARY KEY (`email_addr`))");
			$db->query("INSERT INTO `bbe_admin` VALUES ('bbe user', :user:)", array('user'=>$adminname));
			$db->query("INSERT INTO `bbe_admin` VALUES ('bbe pass', :pass:)", array('pass'=>$passwd));
			header('Location: ' . WEB_ROOT . '/admin.php');
			return; // installed
		}
	}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Install BroadcastByEmail Web Module</title>
<link href="css/style.css" rel="stylesheet" type="text/css" />
</head>

<body>

<div class="main">
<img src="images/top.png" width="860" height="14" alt="" />
<div class="content">
  <div class="topSec"><span>Installer</span>
  </div>

  <h2 class="heading">Welcome</h2>

  <p class="pb15">Welcome to the BroadcastByEmail web module (bbemod) installation. Just fill in the
        information below and you'll be on your way to using Voicent BroadcastByEmail software with your web site.</p>
        
  <h2 class="heading">Information Needed</h2>

<?php 
  	if ($msg != '') {
		echo '<p class="pb15"><b>' . $msg . '</b></p>';
  	} else {
?>

<p class="pb15">Please provide the following information. The admin account is used to manage your subscribers as well as
   open email tracking.</p>

    <form action="install.php" method="POST">
    
        <p class="bulletText pb10">Admin Login Name</p>
	   <p class="pb15">
        <input name="name" type="text" class="textBox" value="" onfocus="javascript:if(this.value=='Enter your user name'){this.value=''}" onblur="javascript:if(this.value==''){this.value=''}" size="20" /></p>
        <p class="bulletText pb10">Admin Password</p>
        <p class="pb15">
        <input name="passwd" type="password" class="textBox" value="" onfocus="javascript:if(this.value=='password'){this.value=''}" onblur="javascript:if(this.value==''){this.value=''}" size="20" /></p>
        <input name="install" type="submit" value="Install Now"/>
    </table>
    </form>
    
<?php } ?>

<?php include 'admin_footer.php'; ?>