package voicent.sample;

import java.sql.*;


// This is a sample Java action for Voicent IVR Studio
// After a caller enters his/her account number and password, IVR Studio
// calls this Java program to check whether the password is correct or not.
//
// In this sample, it is assumed you have created database named AP, 
// a table named AccountPassword with two columns: Account_Id, Account_Password
//
// For more information about Java and Relational database, please take a look
// at Sun Microsystem's JDBC tutorial and samples


public class MyDbPasswordChecker
{
    // Replace the following with your settings
    // This CONN_URL uses Microsoft SQL Server 2005
	static final String CONN_URL = "jdbc:sqlserver://localhost:2424;databaseName=AP;";
	static final String DB_USER = "use your db user name";
	static final String DB_PASSWORD = "use your db password";

    // to return multiple values, use java.util.Properties as return type
    // please see ivr studio tutorial or document for more details
    
    public boolean check(String accountNumber, String passwd)
    {
        Connection con = null;
		Statement stmt = null;
		ResultSet rs = null;
		
		boolean passwdOK = false;
		
        try {
        	// Establish the connection.
        	Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            con = DriverManager.getConnection(CONN_URL, DB_USER, DB_PASSWORD);
            
            // Create and execute an SQL statement
            String sqlst = "SELECT Account_Password FROM AccountPassword " +
                           " WHERE Account_Id = '" + accountNumber + "'";
            
            stmt = con.createStatement();
            rs = stmt.executeQuery(sqlst);
            
            // Check the return data
            if (rs.next()) {
                String passwdSaved = rs.getString(1).trim();
                if (passwdSaved.equals(passwd.trim()))
                    passwdOK = true;
            }
            
            rs.close();
            stmt.close();
        }
		catch (Exception e) {
			e.printStackTrace();
		}
		finally {
	    	if (con != null) try { con.close(); } catch(Exception e) {}
		}
		
        return passwdOK;
    }
    
    // test and customize this program independent of IVR Studio
    // requires MSSQL 2005 JDBC driver library: sqljdbc.jar (free download from microsoft)
    
    public static void main(String args[])
    {
        if (args.length < 2)
            return;
        
        MyDbPasswordChecker checker = new MyDbPasswordChecker();
        boolean rc = checker.check(args[0], args[1]);
        
        System.out.println("The result is: " + Boolean.toString(rc));
    }
}
