package voicent.sample;

import java.util.Properties;
import java.util.Calendar;
import java.text.SimpleDateFormat;
import java.sql.*;


public class RoomReservation 
{
    public Properties doReserve(String theDate, String theTime, String theDuration, String theRoom, String userId)
    {
        Connection conn = null;
        
        String status = "error";
        String info = "ok";

        try {
            // Establish the connection.
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost/room_reservation", "voicent", "close1more");
            
            // is it a valid room?
            String sqlst = "SELECT * FROM room_profile WHERE room_id = " + theRoom;
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlst);
            if (! rs.next()) {
                info = "The room number : " + theRoom + ". is not valid";
            }
            else {
                // check the time slot
                String startTime = getStartDateTime(theDate, theTime);
                String endTime = getEndDateTime(theDate, theTime, theDuration);
                
                sqlst = "SELECT * FROM room_schedule WHERE reserve_status = 'reserved' AND " +
                                 " start_time < '" + endTime + "' AND end_time > '" + startTime + "'";
                Statement stmt1 = conn.createStatement();
                ResultSet rs1 = stmt1.executeQuery(sqlst);

                status = "reserved";
                if (rs1.next())// conflict
                    status = "waiting";
                rs1.close();
                
                String insertst = "INSERT INTO room_schedule VALUES (" + theRoom + ", " + userId + ", '" + status + "', '" +
                                          startTime + "', '" + endTime + "')";
                stmt1.executeUpdate(insertst);
                stmt1.close();
            }

            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            info = e.getMessage();
        }
        finally {
            if (conn != null) try { conn.close(); } catch(Exception e) {}
        }

        // return to IVR apps with a collection of name value pairs
        Properties props = new Properties();
        props.setProperty("status", status);
        props.setProperty("info", info);
        return props;
    }
    
    public int total(String userId)
    {
        Connection conn = null;
        int total = 0;

        try {
            // Establish the connection.
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost/room_reservation", "voicent", "close1more");
            
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = df.format(cal.getTime());
            
            String sqlst = "SELECT COUNT(*) FROM room_schedule WHERE user_id = " + userId + " AND start_time > '" + now + "'";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlst);
            if (rs.next())
                total = rs.getInt(1);

            rs.close();
            stmt.close();
        }
        catch (Exception e) {
        }
        finally {
            if (conn != null) try { conn.close(); } catch(Exception e) {}
        }

        // IVR will convert it to string and name it "result"
        return total;
    }
    
    public Properties getReservation(int index, String userId)
    {
        Connection conn = null;
        Properties props = new Properties();

        try {
            // Establish the connection.
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost/room_reservation", "voicent", "close1more");
            
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = df.format(cal.getTime());
            
            String sqlst = "SELECT * FROM room_schedule WHERE user_id = " + userId + " AND start_time > '" + now + 
                           "' LIMIT " + Integer.toString(index) + ", 1";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlst);
            if (rs.next()) {
                props.setProperty("room_id", Integer.toString(rs.getInt("room_id")));
                props.setProperty("start_time", df.format(rs.getTimestamp("start_time")));
                props.setProperty("end_time", df.format(rs.getTimestamp("end_time")));
            }

            rs.close();
            stmt.close();
        }
        catch (Exception e) {
        }
        finally {
            if (conn != null) try { conn.close(); } catch(Exception e) {}
        }

        return props;
    }
    
    public Properties cancelReservation(String startTime, String endTime, String userId)
    {
        Connection conn = null;
        Properties props = new Properties();

        try {
            // Establish the connection.
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection("jdbc:mysql://localhost/room_reservation", "voicent", "close1more");
            
            String sqlst = "DELETE FROM room_schedule WHERE user_id = " + userId + " AND start_time = '" + startTime + 
                             "' AND end_time = '" + endTime + "'";
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(sqlst);
            
            // now get the first one who is on the waiting list that maybe interested in the slot
            sqlst = "SELECT * FROM room_schedule as R, user_profile as U WHERE R.reserve_status = 'waiting' AND " +
                    " (R.start_time < '" + endTime + "' AND R.end_time > '" + startTime + "') AND " +
                    " R.user_id = U.user_id " +
                    " LIMIT 0, 1";
            ResultSet rs = stmt.executeQuery(sqlst);
            if (rs.next()) {
                props.setProperty("room_id", Integer.toString(rs.getInt("room_id")));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                props.setProperty("start_time", df.format(rs.getDate("start_time")));
                props.setProperty("phone_number", rs.getString("phone_number"));
            }
            else {
                props.setProperty("phone_number", "");
            }
            
            props.setProperty("status", "ok");

            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            props.setProperty("status", e.getMessage());
        }
        finally {
            if (conn != null) try { conn.close(); } catch(Exception e) {}
        }

        return props;
    }
    
    private String getStartDateTime(String theDate, String theTime)
    {
        // input from IVR are YYYYMMDD, HHMM
        return theDate.substring(0, 4) + "-" + theDate.substring(4, 6) + "-" + theDate.substring(6) +
               " " + theTime.substring(0, 2) + ":" + theTime.substring(2) + ":00";
    }
    
    private String getEndDateTime(String theDate, String theTime, String theDuration)
    {
        try {
            String startTime = getStartDateTime(theDate, theTime);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(startTime));
            
            int duration = Integer.parseInt(theDuration);
            cal.add(Calendar.MINUTE, duration);
            return df.format(cal.getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args)
    {
        // some test code here
        RoomReservation rr = new RoomReservation();
        Properties props = rr.doReserve("20120311", "1030", "60", "200", "100");
        props.list(System.out);
        
        props = rr.doReserve("20120311", "1100", "60", "200", "100");
        props.list(System.out);
        
        int total = rr.total("100");
        System.out.println("Total reservations: " + Integer.toString(total));
        
        props = rr.getReservation(0, "100");
        props.list(System.out);
        
        //props = rr.cancelReservation("2012-03-11 10:30:00", "2012-03-11 11:30:00", "100");
        //props.list(System.out);
    }
}
